﻿namespace Plugin {
	/// <summary>Constants for sound indices (sound atsi values).</summary>
	internal static class SoundIndices {
		/// <summary>The AWS bing.</summary>
		internal const int AwsBing = 0;
		/// <summary>The AWS shortened bing.</summary>
		internal const int AwsBingling = 1;
		/// <summary>The AWS horn.</summary>
		internal const int AwsHorn = 2;
		/// <summary>The Vigilance Device beep.</summary>
		internal const int VigilanceBeep = 3;
		/// <summary>The driver to guard communication buzzer.</summary>
		internal const int Buzzer = 4;
		/// <summary>The guard's draw forward buzzer signal.</summary>
//			internal const int DrawForward = 5;
		/// <summary>The guard's set back buzzer signal.</summary>
//			internal const int SetBack = 6;
		
		/// <summary>The diesel engine start motor switching on sound.</summary>
		internal const int DieselEngineStarterMotorSwitchingOn = 7;
		/// <summary>The diesel engine starter motor loop sound.</summary>
		internal const int DieselEngineStarterMotorLoop = 8;
		/// <summary>The diesel engine starter motor running down sound.</summary>
		internal const int DieselEngineStarterMotorRunningDown = 9;
		/// <summary>The diesel engine starting sound.</summary>
		internal const int DieselEngineStart = 10;
		/// <summary>The diesel engine stall on starting sound.</summary>
		internal const int DieselEngineStallOnStart = 11;
		/// <summary>The diesel engine idling sound.</summary>
		internal const int DieselEngineIdle = 12;
		/// <summary>The diesel engine revving up sound.</summary>
		internal const int DieselEngineRevvingUp = 13;
		/// <summary>The diesel engine revving down sound.</summary>
		internal const int DieselEngineRevvingDown = 14;
		/// <summary>The diesel engine stopping sound.</summary>
		internal const int DieselEngineStopping = 15;
		
		/// <summary>The wiper rotary switch sound.</summary>
		internal const int SwitchWiper = 16;
		/// <summary>The wiper sweep sound on wet glass.</summary>
		internal const int WetWipe = 17;
		/// <summary>The wiper sweep sound on dry glass.</summary>
		internal const int DryWipe = 18;
		
		/// <summary>The generic switch sound.</summary>
		internal const int Switch = 24;
		
		/// <summary>The pantograph up air release sound.</summary>
		internal const int PantographUp = 25;
		/// <summary>The air zero sound.</summary>
		internal const int AirZero = 26;
		/// <summary>The vacuum circuit breaker thwok sound.</summary>
		internal const int Thwok = 27;
		/// <summary>The pantograph arcing sound.</summary>
		internal const int PantographArc = 28;
		/// <summary>The pantograph sparking upon touching the contact wire sound.</summary>
		internal const int Sparks = 29;
		
		/// <summary>The guard's ready to start buzzer signal.</summary>
//			internal const int GuardReadyToStart = 31;
		
		/// <summary>The door opening left sound.</summary>
//			internal const int DoorOpenLeft = 40;
		/// <summary>The door opening right sound.</summary>
//			internal const int DoorOpenRight = 41;
		/// <summary>The door closing left sound.</summary>
//			internal const int DoorCloseLeft = 42;
		/// <summary>The door closing right sound.</summary>
//			internal const int DoorCloseRight = 43;
		
		/// <summary>The blower Blower lead-in start sound.</summary>
		internal const int BlowerLoopStart = 50;
		/// <summary>The blower Blower loop sound.</summary>
		internal const int BlowerLoop = 51;
		/// <summary>The blower Blower lead-out stop sound.</summary>
		internal const int BlowerLoopEnd = 52;
		
		/// <summary>The recharge clicks heard after doors have opened (left hand side).</summary>
		internal const int RechargeClicksLeft = 60;
		/// <summary>The recharge clicks heard after doors have opened (right hand side).</summary>
		internal const int RechargeClicksRight = 61;
		/// <summary>The low tone of the horn.</summary>
		internal const int HornAutoLowTone = 62;
		/// <summary>The high tone of the horn.</summary>
		internal const int HornAutoHighTone = 63;
	}
}